define(['app', 'angular'], function (app, angular) {

	app.factory('ErrorHandling', function () {

		var ErrorHandling = {

			add: function (controller, errorMessages) {

				var defaultErrorMessages = controller.errorHandling;
				errorMessages = errorMessages || defaultErrorMessages;

				if (defaultErrorMessages) {
					var DEMKeys = Object.keys(defaultErrorMessages);
					var EMKeys = Object.keys(errorMessages);
					var currentHighestPriority = -1;

					// Take the default defaultErrorMessages keys and find the highest priority
					DEMKeys.forEach(function (DEMKey) {
						if (defaultErrorMessages[DEMKey].priority > currentHighestPriority) {
							currentHighestPriority = defaultErrorMessages[DEMKey].priority;
						}
					});
					// Start the errorMessages priorities from the highest defaultErrorMessage priority
					EMKeys.forEach(function (EMKey) {
						var errorMessage = errorMessages[EMKey];
						if (errorMessage.priority === 0) {
							errorMessage.priority = ++currentHighestPriority;
						}
					});
					// If errorMessage message for the key is empty assign the same value from defaultErrorMessages (keep the priority),
					// otherwise overwrite the errorMessage with defaultErrorMessage ?
					DEMKeys.forEach(function (DEMKey) {
						var errorMessage = errorMessages[DEMKey];
						if (errorMessage && !errorMessage.message && errorMessage.message !== null) {
							errorMessage.message = defaultErrorMessages[DEMKey].message;
						} else {
							errorMessages[DEMKey] = defaultErrorMessages[DEMKey];
						}
					});
				}
				// Let the controller have assess to the msgs
				controller.errorHandling = errorMessages;
			}
		};

		return ErrorHandling;
		/*
		 Bind the error-handling attribute to the parent ng-model and ng-form
		 */
	}).directive('errorHandling', function (ErrorHandling) {
		return {
			restrict: 'A',
			require: ['?^ngModel', '^form'],
			link: function (scope, elem, attrs, controllers) {
				var ngModelCtrl = controllers[0];
				var parentFormCtrl = controllers[1];

				scope.$watch(attrs.errorHandling, function (newVal) {
					ErrorHandling.add(ngModelCtrl || parentFormCtrl, scope.$eval(attrs.errorHandling));
				});
			}

		};
	});
});